clc
clear all
close all

trk = gpxread('2018-11-07 12_14_17', 'FeatureType', 'track');
timeStr = strrep(trk.Time, 'T', ' ');
timeStr = strrep(timeStr, '.000Z', '');
trk.DateNumber = datenum(timeStr,'yyyy-mm-dd HH:MM:SS', 31);
day = fix(trk.DateNumber(1));
trk.TimeOfDay = trk.DateNumber - day;

GPS(:,1)=round(trk.TimeOfDay*86400);
GPS(:,2)=trk.Latitude;
GPS(:,3)=trk.Longitude;
GPS(:,4)=trk.Elevation;

kmlwriteline('2018-11-07 12_14_17', GPS(:,2),GPS(:,3),GPS(:,4));
